package gov.va.med.mhv.usermgmt.data.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "USER_ACCEPT_TERMS_HIST")
public class UserAcceptTermsHistory implements Serializable { //extends AbstractBaseEntity {

	private static final long serialVersionUID = -2579618217434495689L;

	@Id
	@Column(name = "USER_ACCEPT_TERMS_HIST_ID")	
	@GeneratedValue(strategy = GenerationType.AUTO) 
 	private Long id;
	
	@Version 
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "USER_UPDATED_TIME")
	@Temporal(TemporalType.TIMESTAMP)
	private Date userUpdatedTime;

	@Column(name = "ACCEPTED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean accepted;

	@Column(name = "USER_PROFILE_ID")
	private Long userProfileId;

	@Column(name = "TERMS_CONDITIONS_VER_HIST_ID", updatable = false)
	private Long termsCondVerHistId;

	public Long getId() {
		return id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}
	
	public Integer getOplock() {
		return oplock;
	}
	
	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}
	
	public Date getUserUpdatedTime() {
		return userUpdatedTime;
	}
	
	public void setUserUpdatedTime(Date userUpdatedTime) {
		this.userUpdatedTime = userUpdatedTime;
	}
	
	public Boolean getAccepted() {
		return accepted;
	}
	
	public void setAccepted(Boolean accepted) {
		this.accepted = accepted;
	}
	
	public Long getUserProfileId() {
		return userProfileId;
	}
	
	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	
	public Long getTermsCondVerHistId() {
		return termsCondVerHistId;
	}
	
	public void setTermsCondVerHistId(Long termsCondVerHistId) {
		this.termsCondVerHistId = termsCondVerHistId;
	}
	
}
